% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batchProcessZoomOutput.R
\name{batchProcessZoomOutput}
\alias{batchProcessZoomOutput}
\title{Batch process files that have been downloaded from Zoom}
\usage{
batchProcessZoomOutput(batchInput, exportZoomRosetta = NULL)
}
\arguments{
\item{batchInput}{String giving the location of the xlsx file
that contains the information for the zoom meetings. All corresponding
Zoom downloads for the meetings in the batch must be saved in the same
directory as the batchInput file.}

\item{exportZoomRosetta}{optional string giving the path for exporting the
zoomRosetta file to link up unique individual IDs manually. Providing this
path will write the zoomRosetta file to that location.}
}
\value{
a list that has a data.frame for each of the elements
of a Zoom output that are available in the input directory:
\itemize{
\item batchInfo - Each row is a meeting included in batchInput. Columns
provide information about each meeting.
\item meetInfo - Each row is a meeting for which there was a downloaded
participants file. Columns provide information about the meeting from the Zoom
Cloud recording site.
\item partInfo - Each row is a Zoom display name (with display name changes
in parentheses). Columns provide information about participants from the Zoom Cloud
recording site.
\item transcript - Each row is an utterance in the audio transcript. This is the
output from processZoomTranscript.
\item chat - Each row is a message posted to the chat. This is the output
from processZoomChat.
\item rosetta - Each row is a unique display name (within meeting) encountered
in the batchInput. This is used to reconcile user identities.
}
}
\description{
Provide the location of a structured batchInput file and this
function will process a set of meetings at once.
}
\examples{
batchOut = batchProcessZoomOutput(batchInput=system.file('extdata', 
'myMeetingsBatch.xlsx', package = 'zoomGroupStats'), 
exportZoomRosetta=file.path(tempdir(),"_rosetta.xlsx"))

}
