% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{sample_transcript_processed}
\alias{sample_transcript_processed}
\title{Parsed spoken language in a 'Zoom' meeting.}
\format{
A data frame with 30 rows of 12 variables:
\describe{
\item{batchMeetingId}{a character meeting identification variable}
\item{userName}{'Zoom' display name attached to this speaker}
\item{utteranceId}{an incremented numeric identifier for a marked speech utterance}
\item{utteranceStartSeconds}{when the utterance started as the number of seconds from the start of the recording}
\item{utteranceStartTime}{timestamp for the start of the utterance}
\item{utteranceEndSeconds}{when the utterance ended as the number of seconds from the start of the recording}
\item{utteranceEndTime}{timestamp for the end of the utterance}
\item{utteranceTimeWindow}{duration of the utterance, in seconds}
\item{utteranceMessage}{the text of the utterance}
\item{utteranceLanguage}{language code of the utterance}
\item{userEmail}{character email address}
\item{userId}{numeric id of each speaker}
}
}
\source{
\url{http://zoomgroupstats.org/}
}
\usage{
sample_transcript_processed
}
\description{
Parsed spoken language in a 'Zoom' meeting.
}
\keyword{datasets}
