% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{represent_enrichment}
\alias{represent_enrichment}
\title{Graphic representation of enrichment}
\usage{
represent_enrichment(enrichment, plot = "heatmap", scale = "log",
  low = "steelblue", high = "white", nrow = 1, sample_name = "Sample",
  na.value = "grey")
}
\arguments{
\item{enrichment}{Data frame or list of dataframes with p-values or corrected p-values (whenever available) 
and module names for representation.
The name of the dataframe will be used as sample name.}

\item{plot}{Any of "heatmap" or "bar"}

\item{scale}{Any of "log", "identity" or "reverselog" (i.e. -log10(p-value))}

\item{low}{Color to be used in heatmap mode corresponding to lowest value}

\item{high}{Color to be used in heatmap mode corresponding to highest value}

\item{nrow}{Number of rows of the grid for display in bar mode.}

\item{sample_name}{used only is enrichment is a dataframe}

\item{na.value}{color for the missing values in the heatmap}
}
\value{
Function returns a ggplot2 object if input is a dataframe or a gridExtra object if the output is a list.
}
\description{
Graphic representation of enrichment
}
\examples{
represent_enrichment(enrichment = enrichment_test,scale = "reverselog",
                    sample_name = "test",plot = "bar")

represent_enrichment(enrichment = list(SampleA = enrichment_test, 
                                     SampleB = enrichment_test[1:3,]), 
                     plot = "heatmap", scale = "log")
}

