% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Read_Raw.R
\name{read_AG_raw}
\alias{read_AG_raw}
\title{File reading function for primary accelerometer files}
\usage{
read_AG_raw(file, output_window_secs = 1, verbose = FALSE, skip = 10)
}
\arguments{
\item{file}{A character scalar giving path to primary accelerometer file}

\item{output_window_secs}{the desired epoch length; defaults to one second}

\item{verbose}{A logical scalar: Print processing updates?}

\item{skip}{Header length: Number of rows to skip when reading the file}
}
\value{
A dataframe giving processed raw data from the primary accelerometer in the specified epoch length
}
\description{
File reading function for primary accelerometer files
}
\examples{
raw_file <-
    system.file("extdata",
    "TestID_LeftWrist_RAW.csv",
    package = "AGread")

read_AG_raw(raw_file)

}
