% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/first_isolates.R
\name{first_isolate}
\alias{first_isolate}
\title{Determine first (weighted) isolates}
\usage{
first_isolate(tbl, col_date, col_patient_id, col_genus, col_species,
  col_testcode = NA, col_specimen, col_icu, col_keyantibiotics = NA,
  episode_days = 365, testcodes_exclude = "", icu_exclude = FALSE,
  filter_specimen = NA, output_logical = TRUE, points_threshold = 2,
  info = TRUE)
}
\arguments{
\item{tbl}{a \code{data.frame} containing isolates.}

\item{col_date}{column name of the result date (or date that is was received on the lab)}

\item{col_patient_id}{column name of the unique IDs of the patients}

\item{col_genus}{column name of the genus of the microorganisms}

\item{col_species}{column name of the species of the microorganisms}

\item{col_testcode}{column name of the test codes. Use \code{col_testcode = NA} to \strong{not} exclude certain test codes (like test codes for screening). In that case \code{testcodes_exclude} will be ignored.}

\item{col_specimen}{column name of the specimen type or group}

\item{col_icu}{column name of the logicals (\code{TRUE}/\code{FALSE}) whether a ward or department is an Intensive Care Unit (ICU)}

\item{col_keyantibiotics}{column name of the key antibiotics to determine first \emph{weighted} isolates, see \code{\link{key_antibiotics}}.}

\item{episode_days}{episode in days after which a genus/species combination will be determined as 'first isolate' again}

\item{testcodes_exclude}{character vector with test codes that should be excluded (caseINsensitive)}

\item{icu_exclude}{logical whether ICU isolates should be excluded}

\item{filter_specimen}{specimen group or type that should be excluded}

\item{output_logical}{return output as \code{logical} (will else the values \code{0} or \code{1})}

\item{points_threshold}{points until the comparison of key antibiotics will lead to inclusion of an isolate, see Details}

\item{info}{print progress}
}
\value{
A vector to add to table, see Examples.
}
\description{
Determine first (weighted) isolates of all microorganisms of every patient per episode and (if needed) per specimen type.
}
\details{
\strong{Why this is so important} \cr
    To conduct an analysis of antimicrobial resistance, you should only include the first isolate of every patient per episode \href{https://www.ncbi.nlm.nih.gov/pubmed/17304462}{[1]}. If you would not do this, you could easily get an overestimate or underestimate of the resistance of an antibiotic. Imagine that a patient was admitted with an MRSA and that it was found in 5 different blood cultures the following week. The resistance percentage of oxacillin of all \emph{S. aureus} isolates would be overestimated, because you included this MRSA more than once. It would be \href{https://en.wikipedia.org/wiki/Selection_bias}{selection bias}.

    \strong{Using parameter \code{points_threshold}} \cr
    To compare key antibiotics, the difference between antimicrobial interpretations will be measured. A difference from I to S|R (or vice versa) means 0.5 points. A difference from S to R (or vice versa) means 1 point. When the sum of points exceeds \code{points_threshold}, an isolate will be (re)selected as a first weighted isolate.
}
\examples{
\dontrun{

# set key antibiotics to a new variable
tbl$keyab <- key_antibiotics(tbl)

tbl$first_isolate <-
  first_isolate(tbl)

tbl$first_isolate_weighed <-
  first_isolate(tbl,
                col_keyantibiotics = 'keyab')

tbl$first_blood_isolate <-
  first_isolate(tbl,
                filter_specimen = 'Blood')

tbl$first_blood_isolate_weighed <-
  first_isolate(tbl,
                filter_specimen = 'Blood',
                col_keyantibiotics = 'keyab')

tbl$first_urine_isolate <-
  first_isolate(tbl,
                filter_specimen = 'Urine')

tbl$first_urine_isolate_weighed <-
  first_isolate(tbl,
                filter_specimen = 'Urine',
                col_keyantibiotics = 'keyab')

tbl$first_resp_isolate <-
  first_isolate(tbl,
                filter_specimen = 'Respiratory')

tbl$first_resp_isolate_weighed <-
  first_isolate(tbl,
                filter_specimen = 'Respiratory',
                col_keyantibiotics = 'keyab')
}
}
\keyword{first}
\keyword{isolate}
\keyword{isolates}
