% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{microorganisms.old}
\alias{microorganisms.old}
\title{Data set with old taxonomic data from ITIS}
\format{A \code{\link{data.frame}} with 2,383 observations and 4 variables:
\describe{
  \item{\code{tsn}}{Old Taxonomic Serial Number (TSN), as defined by ITIS}
  \item{\code{name}}{Old taxonomic name of the microorganism as found in ITIS, see Source}
  \item{\code{tsn_new}}{New Taxonomic Serial Number (TSN), as defined by ITIS}
  \item{\code{ref}}{Author(s) and year of concerning publication as found in ITIS, see Source}
}}
\source{
[3] Integrated Taxonomic Information System (ITIS) on-line database, \url{https://www.itis.gov}.
}
\usage{
microorganisms.old
}
\description{
A data set containing old (previously valid or accepted) taxonomic names according to ITIS. This data set is used internally by \code{\link{as.mo}}.
}
\section{ITIS}{

\if{html}{\figure{itis_logo.jpg}{options: height=60px style=margin-bottom:5px} \cr}
This package contains the \strong{complete microbial taxonomic data} (with all  seven taxonomic ranks - from subkingdom to subspecies) from the publicly available Integrated Taxonomic Information System (ITIS, \url{https://www.itis.gov}).

The complete taxonomic kingdoms Bacteria, Fungi and Protozoa are included in this package, as well as all previously accepted names known to ITIS. Furthermore, the responsible authors and year of publication are available too. This allows users to use authoritative taxonomic information for their data analyses on any microorganisms, not only human pathogens.

ITIS is a partnership of U.S., Canadian, and Mexican agencies and taxonomic specialists [3].
}

\seealso{
\code{\link{as.mo}} \code{\link{mo_property}} \code{\link{microorganisms}}
}
\keyword{datasets}
