% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logrank.R
\name{logrank}
\alias{logrank}
\title{Perform logrank test}
\usage{
logrank(
  x,
  censored,
  groups,
  score.censored = TRUE,
  max.exact.perms = 1e+05,
  nsims.mc = 10000,
  seed = NULL
)
}
\arguments{
\item{x}{Numeric vector of same length as censored, groups}

\item{censored}{Binary vector of same length as x, groups}

\item{groups}{Factor of same length as x, censored}

\item{score.censored}{Boolean indicating whether or not to score censored values (defaults to \code{TRUE})}

\item{max.exact.perms}{Maximum number of permutations allowed for exact calculations (defaults to \code{100000})}

\item{nsims.mc}{Number of Monte Carlo simulations to be performed (defaults to \code{10000})}

\item{seed}{Random number seed to be used for Monte Carlo simulations (defaults to \code{NULL})}
}
\value{
An ANSMtest object with the results from applying the function
}
\description{
\code{logrank()} performs the logrank test and is used in chapter 9 of "Applied Nonparametric Statistical Methods" (5th edition)
}
\examples{
# Example 9.6 from "Applied Nonparametric Statistical Methods" (5th edition)
logrank(ch9$samplesAB.survtime, ch9$samplesAB.censor, ch9$samplesAB, score.censored = FALSE)

# Exercise 9.7 from "Applied Nonparametric Statistical Methods" (5th edition)
logrank(ch9$samplesXYZ.survtime, ch9$samplesXYZ.censor, ch9$samplesXYZ)

}
