% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ApotcIndexing.R
\name{renameApotcRun}
\alias{renameApotcRun}
\title{Rename an APackOfTheClones run}
\usage{
renameApotcRun(seurat_obj, old_run_id, new_run_id)
}
\arguments{
\item{seurat_obj}{A Seurat object containing APackOfTheClones data - the
output of \link{RunAPOTC}}

\item{old_run_id}{Character. The current id of the APackOfTheClones run to
be renamed.}

\item{new_run_id}{Character. The new id to assign to the APackOfTheClones
run.}
}
\value{
A Seurat object with the APackOfTheClones run renamed.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

A function to rename an APackOfTheClones run identified by its run id in
a Seurat object.
}
\examples{
pbmc <- RunAPOTC(
    seurat_obj = get(data("combined_pbmc")),
    reduction_base = "umap",
    clonecall = "strict",
    run_id = "run1",
    verbose = FALSE
)

pbmc <- renameApotcRun(pbmc, "run1", "new_run")
# Now "run1" has been renamed to "new_run"

}
