% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_wave.R
\name{sox_spectro}
\alias{sox_spectro}
\title{Create spectrogram image from wave file}
\usage{
sox_spectro(
  path,
  dir_out = "Spectrograms",
  prepend = "spectro_",
  width = NULL,
  height = NULL,
  start = NULL,
  end = NULL,
  rate = "20k",
  dry_run = FALSE,
  quiet = FALSE,
  sox_file_path = NULL,
  skip_check = FALSE
)
}
\arguments{
\item{path}{Character. Path to wave file.}

\item{dir_out}{Character. Output directory.}

\item{prepend}{Character. Text to add to the start of the output file.
Defaults to "spectro_".}

\item{width}{Numeric. Width of the spectrogram image in pixels.}

\item{height}{Numeric. Height of the spectrogram image in pixels.}

\item{start}{Numeric/Character. Start the spectrogram at this time (seconds
or HH:MM:SS format).}

\item{end}{Numeric/Character. End time the spectrogram at this time (seconds
or HH:MM:SS format).}

\item{rate}{Numeric. Audio sampling rate to display (used by the \code{rate}
effect in \code{sox}). This effectively limits the upper frequency of the
spectrogram to rate/2. The default (\code{"20k"}), limits the spectrogram to
10kHz. Use \code{rate = NULL} for no limiting.}

\item{dry_run}{Logical. If \code{TRUE} show the sox command, but do not run (for
debugging and understanding precise details).}

\item{quiet}{Logical. Whether to suppress progress messages and other
non-essential updates.}

\item{sox_file_path}{Path to sox file if not installed at the system level,
otherwise NULL.}

\item{skip_check}{Logical. Should the function skip check to ensure SoX is installed.
This may allow speed ups if running across large numbers of files.}
}
\value{
Does not return anything, but creates a spectrogram image in
\code{dir_out}.
}
\description{
Using the external program \code{SoX} (the Swiss Army knife of sound processing
programs), create a spectrogram image file. Note that you must have \code{SoX}
installed to use this function. Spectrograms will be silently overwritten.
}
\details{
Most arguments are passed through to the \code{seewave::sox()} command.
\itemize{
\item width and height correspond to the \code{-x} and \code{-y} options for the
\code{spectrogram} effect.
\item \code{start} and \code{end} are used by the \code{trim} effect
\item \code{rate} is passed on to the \code{rate} effect
}

Based on code from Sam Hache.
}
\examples{
# Prep sample file
w <- tuneR::sine(440, duration = 300000)
td <- tempdir()
temp_wave <- glue::glue("{td}/test_wave.wav")
tuneR::writeWave(w, temp_wave)

# Create spectrograms

try({sox_spectro(temp_wave)
sox_spectro(temp_wave, rate = NULL)
sox_spectro(temp_wave, start = 2, end = 3)
sox_spectro(temp_wave, start = "0:01", end = "0:04")
sox_spectro(temp_wave, prepend = "")
})

# Clean up
unlink(temp_wave)
unlink("Spectrograms", recursive = TRUE)
}
