% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/G_inverse.R
\name{G.inverse}
\alias{G.inverse}
\title{Obtains the inverse of the genomic relationship matrix G}
\usage{
G.inverse(
  G = NULL,
  A = NULL,
  rcn.thr = 1e-12,
  blend = FALSE,
  pblend = 0.02,
  bend = FALSE,
  eig.tol = NULL,
  align = FALSE,
  digits = 8,
  sparseform = FALSE,
  message = TRUE
)
}
\arguments{
\item{G}{Input of the symmetric genomic relationship matrix \eqn{\boldsymbol{G}} in
full form (\eqn{n \times n}), to obtain its inverse (default = \code{NULL}).}

\item{A}{Input of the pedigree relationship matrix \eqn{\boldsymbol{A}}
to perform blending or aligning in full form.
It should be of the same dimension as the \eqn{\boldsymbol{G}} matrix
 (\eqn{n \times n}) (default = \code{NULL}) (to be deprecated).}

\item{rcn.thr}{A threshold for identifying  the \eqn{\boldsymbol{G}} matrix as an ill-conditioned matrix.
Based on the reciprocal conditional number (default = \code{1e-12}).}

\item{blend}{If \code{TRUE} a "blending" with identity matrix \eqn{\boldsymbol{I}} or pedigree relationship matrix
\eqn{\boldsymbol{A}} (if provided) is performed (default = \code{FALSE}) (to be deprecated).}

\item{pblend}{If blending is requested this is the proportion of the identity matrix \eqn{\boldsymbol{I}} or
pedigree relationship matrix \eqn{\boldsymbol{A}} to blend for (default = \code{0.02}) (to be deprecated).}

\item{bend}{If \code{TRUE} a "bending" is performed by making the matrix near positive definite (default = \code{FALSE}) (to be deprecated).}

\item{eig.tol}{Defines relative positiveness (\emph{i.e.}, non-zero) of eigenvalues compared to the largest one.
It determines which threshold of eigenvalues will be treated as zero (default = \code{NULL}) (to be deprecated).}

\item{align}{If \code{TRUE} the genomic relationship matrix \eqn{\boldsymbol{G}} is aligned to the
pedigree relationship matrix \eqn{\boldsymbol{A}} (default = \code{FALSE}) (to be deprecated).}

\item{digits}{Set up the number of digits in used to round the output matrix (default = \code{8}).}

\item{sparseform}{If \code{TRUE} it generates an inverse matrix in sparse form to be used directly in \pkg{asreml} with
required attributes (default = \code{FALSE}).}

\item{message}{If \code{TRUE} diagnostic messages are printed on screen (default = \code{TRUE}).}
}
\value{
A list with three of the following elements:
\itemize{
\item \code{Ginv}: the inverse of \eqn{\boldsymbol{G}} matrix in full form (only if \code{sparseform = FALSE}).
\item \code{Ginv.sparse}: the inverse of \eqn{\boldsymbol{G}} matrix in sparse form (only if \code{sparseform = TRUE}).
\item \code{status}: the status (\code{ill-conditioned} or \code{well-conditioned}) of
the inverse of \eqn{\boldsymbol{G}} matrix.
\item \code{rcn}: the reciprocal conditional number of the inverse of \eqn{\boldsymbol{G}} matrix.
}
}
\description{
Generates the inverse of a genomic relationship matrix \eqn{\boldsymbol{G}} that is provided.
This input matrix should be of the full form (\eqn{n \times n})
with individual names assigned to
\code{rownames} and \code{colnames}. Several checks for the stability of the matrix are
presented based on the reciprocal conditional number.

In case of an ill-conditioned matrix,
options of blending, bending or aligning before inverting are available.
These options will be deprecated (discontinued)
in future versions of \code{ASRgenomics}
as they can be better implemented in the function \code{G.tuneup()}.

Based on procedures published by Nazarian and Gezan \emph{et al.} (2016).
}
\examples{
# Example: An ill-conditioned matrix.

# Get G matrix.
G <- G.matrix(M = geno.apple, method = "VanRaden")$G
G[1:5, 1:5]

# Get the inverse of G.
GINV <- G.inverse(G = G, bend = FALSE, blend = FALSE, align = FALSE)
GINV$Ginv[1:5, 1:5]
GINV$status

}
\references{
Nazarian A., Gezan S.A. 2016. GenoMatrix: A software package for pedigree-based
and genomic prediction analyses on complex traits. Journal of Heredity 107:372-379.
}
