% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Achilles.R
\name{dropAllScratchTables}
\alias{dropAllScratchTables}
\title{Drop all possible scratch tables}
\usage{
dropAllScratchTables(
  connectionDetails,
  scratchDatabaseSchema,
  tempAchillesPrefix = "tmpach",
  numThreads = 1,
  tableTypes = c("achilles"),
  outputFolder,
  verboseMode = TRUE,
  defaultAnalysesOnly = TRUE
)
}
\arguments{
\item{connectionDetails}{An R object of type \code{connectionDetails} created using the
function \code{createConnectionDetails} in the
\code{DatabaseConnector} package.}

\item{scratchDatabaseSchema}{string name of database schema that Achilles scratch tables were
written to.}

\item{tempAchillesPrefix}{The prefix to use for the "temporary" (but actually permanent)
Achilles analyses tables. Default is "tmpach"}

\item{numThreads}{The number of threads to use to run this function. Default is 1
thread.}

\item{tableTypes}{The types of Achilles scratch tables to drop: achilles}

\item{outputFolder}{Path to store logs and SQL files}

\item{verboseMode}{Boolean to determine if the console will show all execution steps.
Default = TRUE}

\item{defaultAnalysesOnly}{Boolean to determine if only default analyses should be run.
Including non-default analyses is substantially more resource
intensive.  Default = TRUE}
}
\value{
No return value, called to drop interim scratch tables.
}
\description{
Drop all possible scratch tables
}
\details{
Drop all possible Achilles scratch tables
}
