% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sheep_counter.r
\name{sheep_counter}
\alias{sheep_counter}
\title{Sheep counter}
\usage{
sheep_counter(dat, tz = "UTC", interv = "10 mins", datebreaks = "2 hour",
  work_data)
}
\arguments{
\item{dat}{a data frame.}

\item{tz}{the time zone.}

\item{interv}{interval of time, set as 10min.}

\item{datebreaks}{is the distance between breaks in the x-axis. "2 hour" by default.}

\item{work_data}{optional parameter used to import work data.}
}
\value{
a plot.
}
\description{
Computes the empirical probability that a group or an individual are sleeping at a given time of the day.
}
\examples{
# Example 1:
data(act)
# Prob of being sleeping for ID 1 during the baseline sleep
b <- act[act$subject_ID==1 & act$datime_end < as.POSIXct("2017-12-15 00:00:00", tz = "UTC"),]
sheep_counter(b)

}
