% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/individuals_defensive_actual_floor_stats.R
\name{individuals_defensive_actual_floor_stats}
\alias{individuals_defensive_actual_floor_stats}
\title{Individual's defensive actual statistics}
\usage{
individuals_defensive_actual_floor_stats(df1, df2, df3)
}
\arguments{
\item{df1}{Should be a Data Frame that represents the individual defensive statistics of the players. The parameter has to be in the format provided by the data_adjustment() function.}

\item{df2}{Should be a Data Frame that represents the team's statistics. The parameter has to be in the format provided by the team_stats() function.}

\item{df3}{Should be a Data Frame that represents the rival's statistics. The parameter has to be in the format provided by the team_stats() function.}
}
\value{
Data frame with the following individual defensive actual statistics
       \itemize{
                \item Defensive Stops (DStops)
                \item Defensive Scores Possesions (DscPoss)
                \item Defensive Possesions (DPoss)
                \item Stops percentage (STOPS\%)
                \item (TMDPossS\%)
                \item Defensive Rating (DRtg)
        }
}
\description{
The function allows the calculation of individual defensive actual statistics on court
}
\examples{

df1 <- data.frame("Name" = c("Witherspoon ","Team"), "MP" = c(14,200),
"DREB" = c(1,0), "FM" = c(4,0), "BLK" = c(0,0),"TOTAL FM" = c(4,0),
"FTO" = c(0,0),"STL" = c(1,1), "TOTAL FTO " = c(1,0), "FFTA" = c(0,0),
"DFGM" = c(1,0), "DFTM" = c(0,0))

df2 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(3006),
"FGA" = c(6269),"Percentage FG" = c(0.48),"3P" = c(782),"3PA" = c(2242),
"Percentage 3P" = c(0.349),"2P" = c(2224), "2PA" = c(4027),
"Percentage 2P" = c(0.552),"FT" = c(1260),"FTA FG" = c(1728),
"Percentage FT" = c(0.729), "ORB" = c(757),  "DRB" = c(2490),
"TRB" = c(3247), "AST" = c(1803),  "STL" = c(612),"BLK" = c(468),
"TOV" = c(1077),"PF" = c(1471),  "PTS" = c(8054),  "+/-" = c(0))

df3 <- data.frame("G" = c(71), "MP" = c(17090), "FG" = c(2773),
"FGA" = c(6187),"Percentage FG" = c(0.448), "3P" = c(827),
"3PA" = c(2373), "Percentage 3P" = c(0.349),  "2P" = c(1946),
"2PA" = c(3814), "Percentage 2P" = c(0.510), "FT" = c(1270),
"FTA FG" = c(1626),  "Percentage FT" = c(0.781), "ORB" = c(668),
"DRB" = c(2333),"TRB" = c(3001),  "AST" = c(1662),"STL" = c(585),
"BLK" = c(263),   "TOV" = c(1130),  "PF" = c(1544),
"PTS" = c(7643),  "+/-" = c(0))

individuals_defensive_actual_floor_stats(df1,df2,df3)

}
\author{
Fco Javier Cantero \email{fco.cantero@edu.uah.es}

Juan José Cuadrado \email{jjcg@uah.es}

Universidad de Alcalá de Henares
}
