% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/report_log_mass.R
\name{report_log_mass}
\alias{report_log_mass}
\title{report relative masses by particle of a log-normal distribution}
\usage{
report_log_mass(df)
}
\arguments{
\item{df}{is the particle data set - after transport analysis by element}
}
\value{
data frame containing mass-based particle fractions in ambient
location and in distribution delivered through the system.
}
\description{
This function shows the entire table of results by particle diameter.
}
\examples{
df <- particle_dist() # set up particle distribution
params <- set_params_1("D_tube" = 2.54, "Q_lpm" = 100,
"T_C" = 25, "P_kPa" = 101.325) #example system parameters
df <- set_params_2(df, params) #particle size-dependent parameters
df <- probe_eff(df, params, orient = 'h') #probe orientation - horizontal
df <- bend_eff(df, params, method='Zhang', bend_angle=90,
bend_radius=0.1, elnum=3)
df <- tube_eff(df, params, L = 100,
angle_to_horiz = 90, elnum = 3)
report_log_mass(df)

}
