% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_filterMeta.R
\name{monitor_filterMeta}
\alias{monitor_filterMeta}
\alias{monitor_filter}
\title{General purpose metadata filtering for \emph{mts_monitor} objects}
\usage{
monitor_filterMeta(monitor, ...)

monitor_filter(monitor, ...)
}
\arguments{
\item{monitor}{\emph{mts_monitor} object.}

\item{...}{Logical predicates defined in terms of the variables in
\code{monitor$meta}.}
}
\value{
A subset of the incoming \code{mts_monitor}. (A list with
\code{meta} and \code{data} dataframes.)
}
\description{
A generalized metadata filter for \emph{mts_monitor} objects to
choose cases where conditions are true.  Multiple conditions are
combined with \code{&} or separated by a comma. Only rows where the condition
evaluates to TRUE are kept. Rows of \code{monitor$meta} where the condition
evaluates to \code{NA} are dropped. Associated olumns of \code{monitor$data}
are also dropped for internal consistency in the returned \emph{mts_monitor}
object.

\code{monitor_filter()} is an alias for \code{monitor_filterMeta()}.
}
\note{
Filtering is done on variables in \code{monitor$meta}.
}
\examples{
library(AirMonitor)

# Filter based on countyName field
Camp_Fire \%>\%
  monitor_filter(countyName == "Alameda") \%>\%
  monitor_timeseriesPlot(main = "All Alameda County Monitors")

# Filter combining two fields
Camp_Fire \%>\%
  monitor_filter(latitude > 39.5, longitude > -121.5) \%>\%
  monitor_pull("locationName")

# Filter using string matching
Camp_Fire \%>\%
  monitor_filter(stringr::str_detect(locationName, "^San")) \%>\%
  monitor_pull("locationName")

}
\seealso{
\link{monitor_filterDate}

\link{monitor_filterDatetime}
}
