% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pat_loadMonth.R
\name{pat_loadMonth}
\alias{pat_loadMonth}
\title{Load PurpleAir time series data for a month}
\usage{
pat_loadMonth(
  id = NULL,
  label = NULL,
  pas = NULL,
  datestamp = NULL,
  timezone = "America/Los_Angeles"
)
}
\arguments{
\item{id}{PurpleAir sensor 'deviceDeploymentID'.}

\item{label}{PurpleAir sensor 'label'.}

\item{pas}{PurpleAir Synoptic \emph{pas} object.}

\item{datestamp}{Date string in ymd order.}

\item{timezone}{Timezone used to interpret \code{datestamp}.}
}
\value{
A PurpleAir Timeseries \emph{pat} object.
}
\description{
A pre-generated PurpleAir Timeseries \emph{pat} object will be 
loaded for the month requested with \code{datestamp} if available. Data are 
loaded from the archive set with either \code{setArchiveBaseUrl()} or 
\code{setArchiveBaseDir()} for locally archived files.

The \code{datestamp} must be in the following format:

\itemize{
\item{\code{"YYYYmm"}}
}

By default, the current month is loaded.
}
\note{
Archive file names are 
generated with a unique "device-deployment" identifier by combining a unique 
location ID with a unique device ID. These "device-deployment" identifiers 
guarantee that movement of a sensor will result in the creation of a new
time series.

Users may request a \emph{pat} object in one of two ways:

1) Pass in \code{id} with a valid a \code{deviceDeploymentID}

2) Pass in both \code{label} and \code{pas} so that the 
\code{deviceDeploymentID} can be looked up.
}
\examples{
\donttest{
library(AirSensor)

setArchiveBaseUrl("http://data.mazamascience.com/PurpleAir/v1")

# Reference an older 'pas' before this sensor was dropped
pas <- pas_load(20190901, archival = TRUE)

may <- pat_loadMonth(label = "SCNP_20", pas = pas, datestamp = 201905)
pat_multiPlot(may)
}
}
\seealso{
\link{pat_load}

\link{pat_loadLatest}

\link{pat_createNew}
}
