% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Af_cluster_metrics.R
\name{Af_cluster_metrics}
\alias{Af_cluster_metrics}
\title{Function to make a grouped boxplot of metrics from clusters of clonotypes}
\usage{
Af_cluster_metrics(
  input,
  clusters,
  metrics,
  min.nodes,
  colors,
  text.size,
  significance,
  parallel,
  num.cores
)
}
\arguments{
\item{input}{\itemize{
\item list - AntibodyForests-object as output from Af_build()
}}

\item{clusters}{\itemize{
\item named integer - The clusters as output from Af_compare_within_repertoires()
}}

\item{metrics}{\itemize{
\item string - The metrics to be calculated per tree
'nr.nodes'         : The total number of nodes
'nr.cells'         : The total number of cells in this clonotype
'mean.depth'       : Mean of the number of edges connecting each node to the germline
'mean.edge.length' : Mean of the edge lengths between each node and the germline
'group.depth'      : Mean of the number of edges connecting each node per group (node.features of the AntibodyForests-object) to the germline. (default FALSE)
'sackin.index'     : Sum of the number of nodes between each terminal node and the germline, normalized by the total number of terminal nodes.
'spectral.density' : Metrics of the spectral density profiles (calculated with package RPANDA)
\itemize{
\item peakedness            : Tree balance
\item asymmetry             : Shallow or deep branching events
\item principal eigenvalue  : Phylogenetic diversity
\item modalities            : The number of different structures within the tree
}
}}

\item{min.nodes}{The minimum number of nodes for a tree to be included in this analysis (this included the germline). This should be the same as for the Af_compare_within_repertoires() functions.}

\item{colors}{\itemize{
\item string -  Optionally specific colors for the clusters
}}

\item{text.size}{Font size in the plot (default 20).}

\item{significance}{\itemize{
\item boolean - If TRUE, the significance of a T test between the groups is plotted (default FALSE)
}}

\item{parallel}{If TRUE, the metric calculations are parallelized across clonotypes. (default FALSE)}

\item{num.cores}{Number of cores to be used when parallel = TRUE. (Defaults to all available cores - 1)}
}
\value{
\itemize{
\item list - A list with boxplots per metric
}
}
\description{
Function to compare metrics between clusters of clontoypes
}
\examples{
plot <- Af_cluster_metrics(input = AntibodyForests::small_af,
                            clusters = AntibodyForests::compare_repertoire[["clustering"]],
                            metrics = "mean.depth",
                            min.nodes = 8)
plot$mean.depth
}
