% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgroClimateData.R
\docType{data}
\name{AgroClimateData}
\alias{AgroClimateData}
\title{Example AgroClimate data from AgERA5}
\format{
A data frame containing daily observations of AgroClimate parameters:
\describe{
\item{\code{GridID}}{Grid id of the location.}
\item{\code{Lat}}{latitude of the site in decimal degrees.}
\item{\code{Lon}}{longitude of the site in decimal degrees.}
\item{\code{Elev}}{elevation above sea level in (meters).}
\item{\code{WHC}}{water holding capacity in (mm).}
\item{\code{Year}}{year of record "YYYY".}
\item{\code{Month}}{month of record "MM".}
\item{\code{Day}}{day of record "DD".}
\item{\code{Rain}}{Precipitation (mm/day).}
\item{\code{Tmax}}{Temperature at 2 Meters Maximum (°C).}
\item{\code{Tmin}}{Temperature at 2 Meters Minimum (°C).}
\item{\code{Rs}}{CAll Sky Surface Shortwave Downward Irradiance
(MJ/m^2/day).}
\item{\code{Tdew}}{Dew/Frost Point at 2 Meters (°C).}
\item{\code{Uz}}{Wind Speed at 2 Meters (m/s).}
}
}
\source{
\url{https://cds.climate.copernicus.eu/cdsapp#!/dataset/sis-agrometeorological-indicators?tab=overview}
}
\usage{
AgroClimateData
}
\description{
The AgERA5 dataset provides daily surface meteorological data
for the period from 1979 to present as input for agriculture
and agro-ecological studies. This dataset is based on the hourly ECMWF ERA5
data at surface level, the data from 01/01/1982 through 12/31/2022 extracted
for a grid located in located in Angochen, Nampula province of Mozambique.
}
\examples{
# load example data:
data(AgroClimateData)

# Get the structure of the data frame:
str(AgroClimateData)

# Get the head of the data frame:
head(AgroClimateData)

}
\references{
AgERA5, 2021, Copernicus Climate Change Service (C3S), Fifth
generation of ECMWF atmospheric reanalysis of the global
climate for agriculture and ago-ecological studies. Copernicus Climate
Change Service Climate Data Store (CDS), July-2021.
}
\seealso{
\code{\link{climateData}, \link{calcEto}}
}
\keyword{datasets}
