% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AgeDepth.R
\name{AgeDepth}
\alias{AgeDepth}
\title{age depth curve
Compute the age-depth curve from the output of mcmc algorithm of ages  and the known depth of each dated samples.}
\usage{
AgeDepth(
  data,
  depth,
  new.depth = NULL,
  max.iter = nrow(data),
  sampling = FALSE
)
}
\arguments{
\item{data}{Data frame containing the output of the MCMC algorithm.}

\item{depth}{Vector of the depths of the dated samples}

\item{new.depth}{Vector of the undated depths whose the age will be predict. By defauft \code{new.depth=NULL}}

\item{max.iter}{a non-negative integer giving the limit number of MCMC  itereations  By defauft \code{max.iter=nrow(data)}}

\item{sampling}{should sampling be random. By defauft \code{sampling = FALSE}}
}
\value{
A list  containing two matrix.  \code{data.stat} summarises the MCMC output from the L1 Bayes estimate and  credible interval
at significance level 68\% and 95\%. \code{age.depth} provide the L1 Bayes estimate, credible interval
at significance level 68\% and 95\% on the age  at depth \code{depth} and \code{new.depth}
}
\description{
age depth curve
Compute the age-depth curve from the output of mcmc algorithm of ages  and the known depth of each dated samples.
}
\details{
Estimate the Age-Depth relationship from the MCMC output of a Bayesian chronological model and the depth of each dated sample.
We assume it exists a function \eqn{f} relating the age and  the depth \eqn{ age = f( depth) }. We estimate the function using local regression (also called local polynomial regression):   \eqn{f = loess(age ~ depth)}.
This  estimated function \eqn{f} depends on the unknown dates.  However, from the posterior distribution of the age/date sequence, we can evaluate the posterior distribution of the age function for each desired depth.
}
\examples{

   data = matrix(rnorm(6000,(1:6)^2), ncol=6 , byrow = TRUE )
   depth= 1:6
   AgeDepth(data,depth)
   AgeDepth(data,depth, 1.5:6)

}
\references{
D.K. Jha , P. Sanyal and A. Philippe 2020.  Multi-Proxy Evidence of Late Quaternary Climate and Vegetational History of North-Central India: Implication for the Paleolithic to Neolithic Phases. Quaternary Science Reviews 229: 106-121.

S. Ghosh, P. Sanyal, R. Bhushan, S. P Sati, A. Philippe, and N. Juyal. 2020. Early Holocene Indian summer monsoon and its impact on vegetation in the Central Himalaya. The Holecene 30:7, 1063-1074.
}
\author{
Anne Philippe, \email{Anne.Philippe@univ-nantes.fr}
}
