% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotBinning.R
\name{depthFill}
\alias{depthFill}
\alias{residualFill}
\alias{importanceFill}
\title{Generate fills encoding bin features}
\usage{
depthFill(bins, colrng = c("white", "firebrick"))

residualFill(
  bins,
  resFun = binChi,
  maxRes,
  colrng = c("steelblue", "white", "firebrick"),
  breaks = NA,
  nbr = NA
)

importanceFill(
  bins,
  nbr = NA,
  breaks = NA,
  colrng = c("steelblue", "white", "firebrick")
)
}
\arguments{
\item{bins}{list of bins to be visualized}

\item{colrng}{hue range to be passed to `colorRampPalette` to
generate the final hue scale}

\item{resFun}{function which returns a result with a name element
`residuals` that is a numeric vector of the same length as `bins`}

\item{maxRes}{numeric maximum value of the residuals to maintain
the correct origin, taken to be the maximum observed residual if
not provided}

\item{breaks}{numeric vector of breakpoints to control hues,
defaults to breakpoints that indicate Pearson residuals outside
the asymptotic 95 percent confidence interval around zero under
the null}

\item{nbr}{number of breakpoints for automatic breakpoint
generation if `breaks` is not provided}
}
\value{
A vector of colours the same length as `bins`.
}
\description{
These functions all accept a list of bins and return
a vector of colours of the same length that encode some feature of
the bins. importanceFill is a special case which adjusts the
residuals obtained by the binChi function by the variance of each
bin to obtain a better normal approximation and then only shades
those bins which are greater than 2 standard deviations from the
mean with a color ramp that fully saturates for any bins which
are greater than a 0.001 standard normal quantile with a
Bonferroni correction applied to account for the number of bins.
}
\details{
Shadings

Two functions are provided by default: one which
generates a fill based on bin depth and the other based on a
residual function applied to each bin.
}
\section{Functions}{
\itemize{
\item \code{depthFill()}: Fill by depth

\item \code{residualFill()}: Fill by residual values

\item \code{importanceFill()}: Fill by variance-adjusted chi residuals

}}
\examples{
bin <- makeBin(x = 1:10, y = sample(1:10))
bin2 <- halfSplit(bin, "x")
bin3 <- unlist(lapply(bin2, maxScoreSplit,
                      scorer = chiScores, minExp = 2),
               recursive = FALSE)
plotBinning(bin3, fill = depthFill(bin3)) # all the same depth
plotBinning(bin3, fill = residualFill(bin3)) # diff resids
}
\author{
Chris Salahub
}
