% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/TW_main.R
\name{tw}
\alias{tw}
\title{Tracy-Wisdom test}
\usage{
tw(eigenvalues, eigenL, criticalpoint = 2.0234)
}
\arguments{
\item{eigenvalues}{a numeric vector whose elements are the
eigenvalues of a matrix. The values should be sorted in the
descending order.}

\item{eigenL}{the number of the eigenvalues.}

\item{criticalpoint}{a numeric value corresponding to the
significance level. If the significance level is 0.05, 0.01,
0.005, or 0.001, the critical point should be set to be 0.9793,
2.0234, 2.4224, or 3.2724, accordingly. The default is 2.0234.}
}
\value{
A list of \code{SigntEigenL} and
\code{TW.stat}. \code{SigntEigenL} is the number of the
significant eigenvalues and \code{TW.stat} is a vector of the
Tracy-Wisdom statistics.
}
\description{
Find the significant eigenvalues of a matrix.
}
\examples{
tw(eigenvalues = c(5, 3, 1, 0), eigenL = 4, criticalpoint = 2.0234)
}
\author{
Lin Wang, Wei Zhang, and Qizhai Li.
}
\references{
N Patterson, AL Price, and D Reich. Population
structure and eigenanalysis. \emph{PloS Genetics}. 2006; 2(12):
2074-2093.

CA Tracy and H Widom. Level-spacing distributions and
the Airy kernel. \emph{Communications in Mathematical
Physics}. 1994; 159(1): 151-174.
}

