% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_acr_methods.R
\name{get_acr}
\alias{get_acr}
\alias{list_acrs}
\title{Get Azure Container Registry (ACR)}
\description{
Method for the \link[AzureRMR:az_resource_group]{AzureRMR::az_resource_group} class.
}
\section{Usage}{
\preformatted{get_acr(name)
list_acrs()
}
}

\section{Arguments}{

\itemize{
\item \code{name}: For \code{get_acr()}, the name of the container registry resource.
}
}

\section{Details}{

The \code{AzureRMR::az_resource_group} class has both \code{get_acr()} and \code{list_acrs()} methods, while the \code{AzureRMR::az_subscription} class only has the latter.
}

\section{Value}{

For \code{get_acr()}, an object of class \code{az_container_registry} representing the registry resource.

For \code{list_acrs()}, a list of such objects.
}

\examples{
\dontrun{

rg <- AzureRMR::get_azure_login()$
    get_subscription("subscription_id")$
    get_resource_group("rgname")

rg$get_acr("myregistry")

}
}
\seealso{
\link{create_acr}, \link{delete_acr}

\link{az_container_registry}

\link{docker_registry} for the registry endpoint

\href{https://docs.microsoft.com/en-us/azure/container-registry/}{ACR documentation} and
\href{https://docs.microsoft.com/en-us/rest/api/containerregistry/registries}{API reference}

\href{https://docs.docker.com/registry/spec/api/}{Docker registry API}
}
