% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batch.R
\docType{class}
\name{graph_request}
\alias{graph_request}
\title{Microsoft Graph request}
\format{
An R6 object of class \code{graph_request}.
}
\description{
Class representing a request to the Microsoft Graph API. Currently this is used only in building a batch call.
}
\section{Methods}{

\itemize{
\item \code{new(...)}: Initialize a new request object with the given parameters. See 'Details' below.
\item \code{batchify()}: Generate a list object suitable for incorporating into a call to the batch endpoint.
}
}

\section{Details}{

The \code{initialize()} method takes the following arguments, representing the components of a HTTPS request:
\itemize{
\item \code{op}: The path of the HTTPS URL, eg \verb{/me/drives}.
\item \code{body}: The body of the HTTPS request, if it is a PUT, POST or PATCH.
\item \code{options}: A list containing the query parameters for the URL.
\item \code{headers}: Any optional HTTP headers for the request.
\item \code{encode}: If a request body is present, how it should be encoded when sending it to the endpoint. The default is \code{json}, meaning it will be sent as JSON text; an alternative is \code{raw}, for binary data.
\item \code{http_verb}: One of "GET" (the default), "DELETE", "PUT", "POST", "HEAD", or "PATCH".
}

This class is currently used only for building batch calls. Future versions of AzureGraph may be refactored to use it in general API calls as well.
}

\examples{
graph_request$new("me")

# a new email message in Outlook
graph_request$new("me/messages",
    body=list(
        body=list(
            content="Hello from R",
            content_type="text"
        ),
        subject="Hello",
        toRecipients="bob@example.com"
    ),
    http_verb="POST"
)
}
\seealso{
\link{call_batch_endpoint}

\href{https://docs.microsoft.com/en-us/graph/overview}{Microsoft Graph overview},
\href{https://docs.microsoft.com/en-us/graph/json-batching}{Batch endpoint documentation}
}
