% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/web_scraping.R
\name{get_daily_weather}
\alias{get_daily_weather}
\title{Scrape daily weather records for Bath}
\usage{
get_daily_weather(from, to)
}
\arguments{
\item{from}{A date or date-time object, or YYYY-MM-DD string: the first day
from which to get a weather summary.}

\item{to}{A date or date-time object, or YYYY-MM-DD string: the last day
from which to get a weather summary.}
}
\value{
A data frame of daily weather summaries for each day in the specified
 range.
}
\description{
This function scrapes the \href{https://www.wunderground.com/}{Wunderground}
 website to get daily weather summaries for Bath over a given date range.
}
\examples{
# Return weather summary for 01 January 2015
weather <- get_daily_weather("2015-01-01", "2015-01-01")
\dontrun{
# Return daily weather summaries from 01 Oct 2014 to 17 Jul 2016
weather <- get_daily_weather("2014-10-01", "2016-07-17")


# Return daily event counts for all days in date range of parking records

library(lubridate)

raw_data <- get_all_crude()
df <- refine(raw_data)

weather <- rbind(get_daily_weather(min(df$LastUpdate), max(df$LastUpdate))
}
}
