% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process_records.R
\name{refine}
\alias{refine}
\title{Clean up raw records}
\usage{
refine(x, max_prop = 1.1, first_upload = FALSE)
}
\arguments{
\item{x}{A data frame containing records to be cleaned up (e.g. the data
frame obtained by calling \code{\link{get_all_crude}}).}

\item{max_prop}{The point at which records are discarded due to overly-full
Occupancy values (default is 1.1, or 110\% full, to allow for circulating
cars).}

\item{first_upload}{If \code{TRUE}, ensures that when duplicate records are
removed, the copy which is kept is the first one uploaded after the record
was taken. This takes much longer to run, due to sorting.}
}
\value{
A data frame of clean records, with 7 columns:
\describe{
 \item{Name}{The name of the car park where the record was taken.}
 \item{LastUpdate}{The time the record was taken (POSIXct date-time object).}
 \item{DateUploaded}{The time the record was uploaded to the Bath: Hacked
     database (POSIXct date-time object).}
 \item{Occupancy}{The total number of cars in the car park.}
 \item{Capacity}{The number of parking spaces in the car park.}
 \item{Status}{Description of the change in occupancy since the previous
     record from that car park.}
 \item{Proportion}{Calculated as (Occupancy/Capacity).}
}
}
\description{
Uses functions from the \code{dplyr} package to clean up raw records obtained
 from the Bath: Hacked datastore. The process is as follows:
\itemize{
 \item Select columns containing useful information only
 \item Remove any records with NA entries
 \item Remove records for "test car park"
 \item Convert Name and Status to factors
 \item Remove records with negative occupancies
 \item Calculate Proportion column (Occupancy/Capacity)
 \item Remove records with Proportion greater than \code{max_prop}
 \item Remove duplicate records (see \code{first_upload})
}
}
\examples{
\dontshow{
load(system.file("tests", "testthat", "data", "raw.rda", package = "BANEScarparkinglite"))
refined <- refine(raw)
}
\donttest{
raw_data <- get_all_crude()
some_records <- raw_data[1:1000, ]

dim(some_records)
## 1000   16

df <- refine(raw_data)
dim(df)
## 813   7
}
}
