% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BGVAR.R
\name{dic}
\alias{dic}
\alias{dic.bgvar}
\title{Deviance Information Criterion}
\usage{
dic(object, ...)

\method{dic}{bgvar}(object, ...)
}
\arguments{
\item{object}{An object of class \code{bgvar}.}

\item{...}{Additional arguments.}
}
\value{
Returns a numeric value with the corresponding DIC.
}
\description{
Computes the Deviance information criterion for an object \code{bgvar}.
}
\examples{
\donttest{
library(BGVAR)
data(testdata)
model.mn <- bgvar(Data=testdata,W=W.test,plag=2,draws=100,burnin=100,prior="MN")
dic(model.mn)
}
}
\references{
Spiegelhalter, D. J. and Best, N. G., Carlin, B. P. and Linde, A. (2002) \emph{Bayesian measures of model complexity and fit.} Journal of the Royal Statistical Society, Series B, Vol. 64(4), pp. 583-639.
}
\seealso{
\code{\link{bgvar}} for estimation of a \code{bgvar} object.
}
\author{
Maximilian Boeck
}
