% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/identification.R
\name{fitComponentModel}
\alias{fitComponentModel}
\title{Fit the estimated variance components of a model to covariance data}
\usage{
fitComponentModel(covmat, ...)
}
\arguments{
\item{covmat}{the covariance matrix of the raw data, possibly blockwise.}

\item{...}{Comma-separated relatedness component matrices.}
}
\description{
Fit the estimated variance components of a model to covariance data
}
\details{
Returns a regression (linear model fitted with \code{lm}).
The coefficients of the regression are the estimated variance components.
}
\examples{

\dontrun{
# install.packages("OpenMX")
data(twinData, package = "OpenMx")
sellVars <- c("ht1", "ht2")
mzData <- subset(twinData, zyg \%in\% c(1), c(selVars, 'zyg'))
dzData <- subset(twinData, zyg \%in\% c(3), c(selVars, 'zyg'))

fitComponentModel(
covmat = list(cov(mzData[,selVars], use = "pair"), cov(dzData[,selVars], use = "pair")),
A = list(matrix(1, nrow = 2, ncol = 2), matrix(c(1, 0.5, 0.5, 1), nrow = 2, ncol = 2)),
C = list(matrix(1, nrow = 2, ncol = 2), matrix(1, nrow = 2, ncol = 2)),
E = list(diag(1, nrow = 2), diag(1, nrow = 2))
)
}

}
