% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkSex.R
\name{repairSex}
\alias{repairSex}
\title{Repairs Sex Coding in a Pedigree Dataframe}
\usage{
repairSex(ped, verbose = FALSE, code_male = NULL)
}
\arguments{
\item{ped}{A dataframe representing the pedigree data with a 'sex' column.}

\item{verbose}{A logical flag indicating whether to print progress and validation messages to the console.}

\item{code_male}{The current code used to represent males in the 'sex' column. At least one is needed.}
}
\value{
A modified version of the input data.frame \code{ped}, containing an additional or modified 'sex_recode' column where the 'sex' values are recoded according to \code{code_male}. NA values in the 'sex' column are preserved.
}
\description{
This function serves as a wrapper around `checkSex` to specifically handle
the repair of the sex coding in a pedigree dataframe.
}
\examples{
\dontrun{
ped <- data.frame(ID = c(1, 2, 3), sex = c("M", "F", "M"))
repairSex(ped, code_male = "M", verbose = TRUE)
}
}
\seealso{
\code{\link{checkSex}}
}
