% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_countsMADC.R
\name{get_countsMADC}
\alias{get_countsMADC}
\title{Obtain Read Counts from MADC File}
\usage{
get_countsMADC(madc_file)
}
\arguments{
\item{madc_file}{Path to MADC file}
}
\value{
A list of read count matrices for reference, alternate, and total read count values
}
\description{
This function takes the MADC file as input and retrieves the ref and alt counts for each sample,
and converts them to ref, alt, and size(total count) matrices for dosage calling tools. At the moment,
only the read counts for the Ref and Alt target loci are obtained while the additional loci are ignored.
}
\examples{
# Get the path to the MADC file
madc_path <- system.file("iris_DArT_MADC.csv", package = "BIGr")

# Extract the read count matrices
counts_matrices <- get_countsMADC(madc_path)

# Access the reference, alternate, and size matrices

# ref_matrix <- counts_matrices$ref_matrix
# alt_matrix <- counts_matrices$alt_matrix
# size_matrix <- counts_matrices$size_matrix

rm(counts_matrices)
}
