% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor_ops.R
\name{TensorOperator}
\alias{TensorOperator}
\title{R6 singleton that contains the configuration for the tensor backend}
\description{
Tensor backend configuration and methods for all the tensor operations
in BKTR
}
\examples{
\dontshow{if (torch::torch_is_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# Set the seed, setup the tensor floating point type and device
TSR$set_params(fp_type='float64', fp_device='cpu', seed=42)
# Create a tensor from a vector
TSR$tensor(c(1, 2, 3))
# Create a tensor from a matrix
TSR$tensor(matrix(c(1, 2, 3, 4), nrow=2))
# Create a 3x3 tensor with a diagonal of ones and zeros elsewhere
TSR$eye(3)
# Create a tensor of ones (with 6 elements, 2 rows and 3 columns)
TSR$ones(c(2, 3))
# Create a tensor of zeros (with 12 elements, 3 rows and 4 columns)
TSR$zeros(c(3, 4))
# Create a tensor of random uniform values (with 6 elements)
TSR$rand(c(2, 3))
# Create a tensor of random normal values (with 6 elements)
TSR$randn(c(2, 3))
# Create a tensor of random normal values with the same shape as a given tensor
tsr_a <- TSR$randn(c(2, 3))
TSR$randn_like(tsr_a)
# Create a tensor of a range of values (1, 2, 3, 4)
TSR$arange(1, 4)
# Choose two random values from a given tensor without replacement
tsr_b <- TSR$rand(6)
TSR$rand_choice(tsr_b, 2)
# Use the tensor operator to compute the kronecker product of two 2x2 matrices
tsr_c <- TSR$tensor(matrix(c(1, 2, 3, 4), nrow=2))
tsr_d <- TSR$tensor(matrix(c(5, 6, 7, 8), nrow=2))
TSR$kronecker_prod(tsr_c, tsr_d) # Returns a 4x4 tensor
# Use the tensor operator to compute the khatri rao product of two 2x2 matrices
TSR$khatri_rao_prod(tsr_c, tsr_d) # Returns a 4x2 tensor
# Check if a given object is a tensor
TSR$is_tensor(tsr_d) # Returns TRUE
TSR$is_tensor(TSR$eye(2)) # Returns TRUE
TSR$is_tensor(1) # Returns FALSE
\dontshow{\}) # examplesIf}
}
\section{Super class}{
\code{\link[R6P:Singleton]{R6P::Singleton}} -> \code{TensorOperator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{fp_type}}{The floating point type to use for the tensor operations}

\item{\code{fp_device}}{The device to use for the tensor operations}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-TensorOperator-new}{\code{TensorOperator$new()}}
\item \href{#method-TensorOperator-set_params}{\code{TensorOperator$set_params()}}
\item \href{#method-TensorOperator-get_default_jitter}{\code{TensorOperator$get_default_jitter()}}
\item \href{#method-TensorOperator-tensor}{\code{TensorOperator$tensor()}}
\item \href{#method-TensorOperator-is_tensor}{\code{TensorOperator$is_tensor()}}
\item \href{#method-TensorOperator-eye}{\code{TensorOperator$eye()}}
\item \href{#method-TensorOperator-ones}{\code{TensorOperator$ones()}}
\item \href{#method-TensorOperator-zeros}{\code{TensorOperator$zeros()}}
\item \href{#method-TensorOperator-rand}{\code{TensorOperator$rand()}}
\item \href{#method-TensorOperator-randn}{\code{TensorOperator$randn()}}
\item \href{#method-TensorOperator-randn_like}{\code{TensorOperator$randn_like()}}
\item \href{#method-TensorOperator-arange}{\code{TensorOperator$arange()}}
\item \href{#method-TensorOperator-rand_choice}{\code{TensorOperator$rand_choice()}}
\item \href{#method-TensorOperator-kronecker_prod}{\code{TensorOperator$kronecker_prod()}}
\item \href{#method-TensorOperator-khatri_rao_prod}{\code{TensorOperator$khatri_rao_prod()}}
\item \href{#method-TensorOperator-clone}{\code{TensorOperator$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-new"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-new}{}}}
\subsection{Method \code{new()}}{
Initialize the tensor operator with the given floating point type
and device
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$new(fp_type = "float64", fp_device = "cpu")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fp_type}}{The floating point type to use for the tensor operations (either
"float64" or "float32")}

\item{\code{fp_device}}{The device to use for the tensor operations (either "cpu" or
"cuda")}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor operator instance
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-set_params"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-set_params}{}}}
\subsection{Method \code{set_params()}}{
Set the tensor operator parameters
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$set_params(fp_type = NULL, fp_device = NULL, seed = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{fp_type}}{The floating point type to use for the tensor operations (either
"float64" or "float32")}

\item{\code{fp_device}}{The device to use for the tensor operations (either "cpu" or
"cuda")}

\item{\code{seed}}{The seed to use for the random number generator}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-get_default_jitter"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-get_default_jitter}{}}}
\subsection{Method \code{get_default_jitter()}}{
Get the default jitter value for the floating point type used by the tensor operator
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$get_default_jitter()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The default jitter value for the floating point type used by the tensor operator
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-tensor"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-tensor}{}}}
\subsection{Method \code{tensor()}}{
Create a tensor from a vector or matrix of data with the tensor operator dtype and device
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$tensor(tensor_data)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor_data}}{The vector or matrix of data to create the tensor from}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-is_tensor"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-is_tensor}{}}}
\subsection{Method \code{is_tensor()}}{
Check if a provided object is a tensor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$is_tensor(tensor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tensor}}{The object to check}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A boolean indicating if the object is a tensor
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-eye"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-eye}{}}}
\subsection{Method \code{eye()}}{
Create a tensor with a diagonal of ones and zeros with the tensor operator dtype and device
for a given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$eye(eye_dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{eye_dim}}{The dimension of the tensor to create}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor with a diagonal of ones and zeros with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-ones"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-ones}{}}}
\subsection{Method \code{ones()}}{
Create a tensor of ones with the tensor operator dtype and device for a given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$ones(tsr_dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tsr_dim}}{The dimension of the tensor to create}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of ones with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-zeros"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-zeros}{}}}
\subsection{Method \code{zeros()}}{
Create a tensor of zeros with the tensor operator dtype and device for a given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$zeros(tsr_dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tsr_dim}}{The dimension of the tensor to create}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of zeros with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-rand"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-rand}{}}}
\subsection{Method \code{rand()}}{
Create a tensor of random uniform values with the tensor operator dtype and
device for a given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$rand(tsr_dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tsr_dim}}{The dimension of the tensor to create}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of random values with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-randn"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-randn}{}}}
\subsection{Method \code{randn()}}{
Create a tensor of random normal values with the tensor operator dtype and device
for a given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$randn(tsr_dim)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{tsr_dim}}{The dimension of the tensor to create}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of random normal values with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-randn_like"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-randn_like}{}}}
\subsection{Method \code{randn_like()}}{
Create a tensor of random uniform values with the same shape as a given tensor
with the tensor operator dtype and device
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$randn_like(input_tensor)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{input_tensor}}{The tensor to use as a shape reference}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of random uniform values with the same shape as a given tensor
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-arange"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-arange}{}}}
\subsection{Method \code{arange()}}{
Create a tensor of a range of values with the tensor operator dtype and device
for a given start and end
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$arange(start, end)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{start}}{The start of the range}

\item{\code{end}}{The end of the range}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of a range of values with the tensor operator dtype and device
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-rand_choice"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-rand_choice}{}}}
\subsection{Method \code{rand_choice()}}{
Choose random values from a tensor for a given number of samples
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$rand_choice(
  choices_tsr,
  nb_sample,
  use_replace = FALSE,
  weights_tsr = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{choices_tsr}}{The tensor to choose values from}

\item{\code{nb_sample}}{The number of samples to choose}

\item{\code{use_replace}}{A boolean indicating if the sampling should be done with replacement.
Defaults to FALSE}

\item{\code{weights_tsr}}{The weights to use for the sampling. If NULL, the sampling is uniform.
Defaults to NULL}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new tensor of randomly chosen values from a tensor
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-kronecker_prod"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-kronecker_prod}{}}}
\subsection{Method \code{kronecker_prod()}}{
Efficiently compute the kronecker product of two matrices in tensor format
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$kronecker_prod(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{The first tensor}

\item{\code{b}}{The second tensor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The kronecker product of the two matrices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-khatri_rao_prod"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-khatri_rao_prod}{}}}
\subsection{Method \code{khatri_rao_prod()}}{
Efficiently compute the khatri rao product of two matrices in tensor format
having the same number of columns
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$khatri_rao_prod(a, b)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{a}}{The first tensor}

\item{\code{b}}{The second tensor}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The khatri rao product of the two matrices
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-TensorOperator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-TensorOperator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{TensorOperator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
