% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{dstddelta_wrap}
\alias{dstddelta_wrap}
\title{Calculates derivatives of all shares with respect to all mean utilities in a given market.}
\usage{
dstddelta_wrap(blp_data, par_theta2, market, printLevel = 1)
}
\arguments{
\item{blp_data}{data object created by the function \code{BLP_data},}

\item{par_theta2}{matrix with column and rownames providing a starting value for the optimization routine (see details),}

\item{market}{character specifying the market in which derivatives are calculated,}

\item{printLevel}{level of output information (default = 1)}
}
\value{
Returns a numeric matrix with derivatives.
Cell in row i and col j is the derivative of share i with respect to mean utility j.
}
\description{
Calculates derivatives of all shares with respect to all mean utilities in a given market.
}
\details{
NA's in \code{par_theta2} entries indicate the exclusion from estimation, i.e. the coefficient is assumed to be zero.
If only unobserved heterogeneity is used (no demographics), the column name of \code{par_theta2} must be "unobs_sd".
With demographics the colnames must match the names of provided demographics (as in \code{demographic_draws}) and "unobs_sd".
Row names of \code{par_theta2} must match random coefficients as specified in \code{model}. Constants must be named "(Intercept)".
}
\examples{
K<-2 #number of random coefficients
data <- simulate_BLP_dataset(nmkt = 25, nbrn = 20,
                        Xlin = c("price", "x1", "x2", "x3", "x4", "x5"),
                        Xexo = c("x1", "x2", "x3", "x4", "x5"),
                        Xrandom = paste0("x",1:K),instruments = paste0("iv",1:10),
                        true.parameters = list(Xlin.true.except.price = rep(0.2,5),
                                               Xlin.true.price = -0.2,
                                               Xrandom.true = rep(2,K),
                                               instrument.effects = rep(2,10),
                                               instrument.Xexo.effects = rep(1,5)),
                        price.endogeneity = list( mean.xi = -2,
                                                  mean.eita = 0,
                                                  cov = cbind( c(1,0.7), c(0.7,1))),
                        printlevel = 0, seed = 234234 )


model <- as.formula("shares ~  price + x1 + x2 + x3 + x4 + x5 |
                    x1 + x2 + x3 + x4 + x5 |
                    0+ x1 + x2 |
                    iv1 + iv2 + iv3 + iv4 + iv5 + iv6 + iv7 + iv8 +iv9 +iv10" )

blp_data <- BLP_data(model = model, market_identifier="cdid",
                     product_id = "prod_id",
                     productData = data,
                     integration_method = "MLHS" ,
                     integration_accuracy = 40,
                     integration_seed = 1)

theta2 <- matrix(c(0.5,2), nrow=2)
rownames(theta2) <- c("x1","x2")
colnames(theta2) <- "unobs_sd"

derivatives2 <- dstddelta_wrap(  blp_data=blp_data,
                                  par_theta2 = theta2,
                                 market = 2)
}
