% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BMORSEnv.R
\name{BMORS_Env}
\alias{BMORS_Env}
\title{Bayesian Multi-Output regression stacking for specific environment estimations}
\usage{
BMORS_Env(
  data = NULL,
  testingEnv = "",
  ETA = NULL,
  covModel = "BRR",
  predictor_Sec_complete = FALSE,
  nIter = 2500,
  burnIn = 500,
  thin = 5,
  progressBar = TRUE,
  digits = 4
)
}
\arguments{
\item{data}{\code{(data.frame)} Phenotypic response where each column is a different trait and the first column are the name of the environment where it was evaluated.}

\item{testingEnv}{\code{(string)} Name of the Environment to test.}

\item{ETA}{\code{(matrix)} This is a two-level list used to specify the regression function (or linear predictor).}

\item{covModel}{\code{(string)} Name of the covariates model to implement (BRR, BayesA, BayesB, BayesC).}

\item{predictor_Sec_complete}{\code{(Logical)} FALSE by default.}

\item{nIter}{\code{(integer)} Number of iterations to fit the model.}

\item{burnIn}{\code{(integer)} Number of items to burn at the beginning of the model.}

\item{thin}{\code{(integer)} Number of items to thin the model.}

\item{progressBar}{\code{(Logical)} Show the progress bar.}

\item{digits}{\code{(integer)} Number of digits of accuracy in the results.}
}
\description{
Bayesian Multi-Output regression stacking for specific environment estimations
}
\examples{
\donttest{
data('MaizeToy')
phenoMaizeToy <- phenoMaizeToy[order(phenoMaizeToy$Env, phenoMaizeToy$Line),]

#Matrix design
LG <- cholesky(genoMaizeToy)
ZG <- model.matrix(~0 + as.factor(phenoMaizeToy$Line))
Z.G <- ZG \%*\% LG
#Linear Predictor
ETA <- list(Gen = list(X = Z.G, model = 'BRR'))

dataset <- phenoMaizeToy[, 2:5] #Must Include in the first column the environments
#Check predictive capacities of the model
pm <- BMORS_Env(dataset, testingEnv = 'EBU', ETA = ETA, covModel = 'BRR', nIter = 10000,
                burnIn = 5000, thin = 2, progressBar = FALSE, digits = 3)
}

}
