% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dc.CreateFreqCBT}
\alias{dc.CreateFreqCBT}
\title{Create Frequency Customer-by-Time Matrix}
\usage{
dc.CreateFreqCBT(elog)
}
\arguments{
\item{elog}{event log, which is a data frame with columns for customer ID ("cust"), date ("date"), and optionally other columns such as "sales". Each row represents an event, such as a transaction. If the dates are not formatted to be in
the order year-month-day, the columns of the customer-by-time
matrix may not be ordered chronologically if the "date" column
does not consist of date objects (R will order them
alphabetically). This will cause problems with other functions, so
it is better to convert the date column to date objects before
running this function.}
}
\value{
Frequency customer-by-time matrix.
}
\description{
Creates a customer-by-time matrix with total number of
transactions per time period.
}
\examples{
# Create event log from file "cdnowElog.csv", which has
# customer IDs in the second column, dates in the third column, and
# sales numbers in the fifth column.
elog <- dc.ReadLines(system.file("data/cdnowElog.csv", package="BTYD"),2,3,5)

# Given that the dates are in the order year-month-day,
# it is not strictly necessary to convert the date column
# to date formats. However, it is good practice:
elog[,"date"] <- as.Date(elog[,"date"], "\%Y\%m\%d")

freq.cbt <- dc.CreateFreqCBT(elog)
}

