% Generated by roxygen2 (4.0.1): do not edit by hand
\name{dc.GetLastPurchasePeriodsFromCBT}
\alias{dc.GetLastPurchasePeriodsFromCBT}
\title{Get Last Purchase Periods from Customer-by-Time Matrix}
\usage{
dc.GetLastPurchasePeriodsFromCBT(cbt)
}
\arguments{
\item{cbt}{customer-by-time matrix. This is a matrix consisting of
a row per customer and a column per time period. It should contain
numeric information about a customer's transactions in every time
period - either the number of transactions in that time period
(frequency), a 1 to indicate that at least 1 transaction occurred
(reach), or the average/total amount spent in that time period.}
}
\value{
a vector containing the indices of periods in which
customers made their last transactions. To convert to actual dates
(if your customer-by-time matrix has dates as column names), use
colnames(cbt)[RESULT]
}
\description{
Uses a customer-by-time matrix to return a vector containing the
periods in which customers made their last purchase.
}

