% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bgnbd.R
\name{bgnbd.EstimateParameters}
\alias{bgnbd.EstimateParameters}
\title{BG/NBD Parameter Estimation}
\usage{
bgnbd.EstimateParameters(
  cal.cbs,
  par.start = c(1, 3, 1, 3),
  max.param.value = 10000,
  method = "L-BFGS-B",
  hessian = FALSE
)
}
\arguments{
\item{cal.cbs}{calibration period CBS (customer by sufficient statistic). It
must contain columns for frequency ("x"), recency ("t.x"), and total time
observed ("T.cal"). Note that recency must be the time between the start of
the calibration period and the customer's last transaction, not the time
between the customer's last transaction and the end of the calibration
period.}

\item{par.start}{initial BG/NBD parameters - a vector with r, alpha, a, and
b, in that order. r and alpha are unobserved parameters for the NBD
transaction process. a and b are unobserved parameters for the Beta
geometric dropout process.}

\item{max.param.value}{the upper bound on parameters.}

\item{method}{the optimization method(s) passed along to
\code{\link[optimx]{optimx}}.}

\item{hessian}{set it to TRUE if you want the Hessian matrix, and then you
might as well have the complete  \code{\link[optimx]{optimx}} object
returned.}
}
\value{
Vector of estimated parameters.
}
\description{
Estimates parameters for the BG/NBD model.
}
\details{
The best-fitting parameters are determined using the
\code{\link{bgnbd.cbs.LL}} function. The sum of the log-likelihood for each
customer (for a set of parameters) is maximized in order to estimate
parameters.

A set of starting parameters must be provided for this method. If no
parameters are provided, (1,3,1,3) is used as a default. These values are
used because they provide good convergence across data sets. It may be useful
to use starting values for r and alpha that represent your best guess of the
heterogeneity in the buy and die rate of customers. It may be necessary to
run the estimation from multiple starting points to ensure that it converges.
To compare the log-likelihoods of different parameters, use
\code{\link{bgnbd.cbs.LL}}.

The lower bound on the parameters to be estimated is always zero, since
BG/NBD parameters cannot be negative. The upper bound can be set with the
max.param.value parameter.

This function may take some time to run.
}
\examples{
data(cdnowSummary)

cal.cbs <- cdnowSummary$cbs
# cal.cbs already has column names required by method

# starting-point parameters
startingparams <- c(1.0, 3, 1.0, 3)

# estimated parameters
est.params <- bgnbd.EstimateParameters(cal.cbs = cal.cbs,
                                       par.start = startingparams)

# complete object returned by \code{\link[optimx]{optimx}}
optimx.set <- bgnbd.EstimateParameters(cal.cbs = cal.cbs,
                                       par.start = startingparams,
                                       hessian = TRUE)

# log-likelihood of estimated parameters
bgnbd.cbs.LL(est.params, cal.cbs)
}
\references{
Fader, Peter S.; Hardie, and Bruce G.S.. "Overcoming the BG/NBD
Model's #NUM! Error Problem." December. 2013. Web.
\url{http://brucehardie.com/notes/027/bgnbd_num_error.pdf}
}
\seealso{
\code{\link{bgnbd.cbs.LL}}
}
