% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/85_transform.R
\name{fred_transform}
\alias{fred_transform}
\alias{fred_code}
\title{FRED transformation and subset helper}
\usage{
fred_transform(
  data,
  type = c("fred_qd", "fred_md"),
  codes,
  na.rm = TRUE,
  lag = 1L,
  scale = 100
)

fred_code(vars, type = c("fred_qd", "fred_md"), table = FALSE)
}
\arguments{
\item{data}{A \code{data.frame} with FRED-QD or FRED-MD time series. The
column names are used to find the correct transformation.}

\item{type}{Character scalar. Whether \emph{data} stems from the FRED-QD or
the FRED-MD database.}

\item{codes}{Integer vector. Transformation code(s) to apply to \emph{data}.
Overrides automatic lookup of transformation codes.}

\item{na.rm}{Logical scalar. Whether to subset to rows without any
\code{NA} values. A warning is thrown if rows are non-sequential.}

\item{lag}{Integer scalar. Number of lags to apply when taking differences.
See \code{\link[base]{diff}}.}

\item{scale}{Numeric scalar. Scaling to apply to log differences.}

\item{vars}{Character vector. Names of the variables to look for.}

\item{table}{Logical scalar. Whether to return a table of matching
transformation codes instead of just the codes.}
}
\value{
\code{\link{fred_transform}} returns a \code{data.frame} object with
applied transformations. \code{\link{fred_code}} returns transformation
codes, or a \code{data.frame} of matching transformation codes.
}
\description{
Apply transformations given by FRED-MD or FRED-QD and generate rectangular
subsets. See \code{\link{fred_qd}} for information on data and the Details
section for information on the transformations. Call without arguments to
retrieve available codes / all FRED suggestions.
}
\details{
FRED-QD and FRED-MD include a transformation code for every variable. All
codes are provided in \code{system.file("fred_trans.csv", package = "BVAR")}.
The transformation codes are as follows:
\enumerate{
  \item \code{1} - no transformation;
  \item \code{2} - first differences - \eqn{\Delta x_t}{Delta x};
  \item \code{3} - second differences - \eqn{\Delta^2 x_t}{Delta2 x};
  \item \code{4} - log transformation - \eqn{\log x_t}{log x};
  \item \code{5} - log differences -
    \eqn{\Delta \log x_t}{Delta log x};
  \item \code{6} - log second differences -
    \eqn{\Delta^2 \log x_t}{Delta2 log x};
  \item \code{7} - percent change differences -
    \eqn{\Delta x_t / x_{t-1} - 1}{Delta x / lag-x - 1};
}
Note that the transformation codes of FRED-MD and FRED-QD may differ for
the same series.
}
\examples{
# Transform a subset of FRED-QD
fred_transform(fred_qd[, c("GDPC1", "INDPRO", "FEDFUNDS")])

# Get info on transformation codes for unemployment variables
fred_code("UNRATE", table = TRUE)

# Get the transformation code for GDPC1
fred_code("GDPC1", type = "fred_qd")

# Transform all of FRED-MD
\dontrun{
fred_transform(fred_md, type = "fred_md")
}
}
\seealso{
\code{\link{fred_qd}}
}
\keyword{FRED}
\keyword{datasets}
