% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,Diffusion-method}
\alias{simulate,Diffusion-method}
\title{Simulation of diffusion process}
\usage{
\S4method{simulate}{Diffusion}(object, nsim = 1, seed = NULL, t, y0,
  mw = 1, plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "Diffusion"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{y0}{starting point of the process}

\item{mw}{mesh width for finer Euler approximation to simulate time-continuity}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of a stochastic process
  \eqn{dY_t = b(\phi,t,Y_t)dt + \gamma \widetilde{s}(t,Y_t)dW_t}.
}
\examples{
model <- set.to.class("Diffusion", parameter = list(phi = 0.5, gamma2 = 0.01))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5, plot.series = TRUE)
}

