% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/simulate.R
\docType{methods}
\name{simulate,Merton-method}
\alias{simulate,Merton-method}
\title{Simulation of jump diffusion process}
\usage{
\S4method{simulate}{Merton}(object, nsim = 1, seed = NULL, t, y0,
  start = c(0, 0), plot.series = TRUE)
}
\arguments{
\item{object}{class object of parameters: "Merton"}

\item{nsim}{number of trajectories to simulate. Default is 1.}

\item{seed}{optional: seed number for random number generator}

\item{t}{vector of time points}

\item{y0}{starting point of process}

\item{start}{vector: start[1] starting point time, start[2] starting point for Poisson process}

\item{plot.series}{logical(1), if TRUE, simulated series are depicted grafically}
}
\description{
Simulation of jump diffusion process
  \eqn{Y_t = y_0 \exp( \phi t - \gamma^2/2 t+\gamma W_t + \log(1+\theta) N_t)}.
}
\examples{
model <- set.to.class("Merton", parameter = list(thetaT = 0.1, phi = 0.05, gamma2 = 0.1, xi = 10))
t <- seq(0, 1, by = 0.01)
data <- simulate(model, t = t, y0 = 0.5)
}

