## ------------------------------------------------------------------------
library("BacArena")

## ------------------------------------------------------------------------
data(Ec_core)
ecore <- Ec_core

## ------------------------------------------------------------------------
bac <- Bac(ecore)

## ------------------------------------------------------------------------
arena <- Arena(n=50, m=50)

## ------------------------------------------------------------------------
arena <- addOrg(arena,bac,amount=1,x=25,y=25)

## ------------------------------------------------------------------------
arena <- addSubs(arena, smax=0.05, unit='mM', difspeed=6.7e-6) 

## ------------------------------------------------------------------------
eval <- simEnv(arena,time=10)

## ------------------------------------------------------------------------
plotCurves2(eval)

## ------------------------------------------------------------------------
evalArena(eval,time=10)

## ------------------------------------------------------------------------
par(mar=c(1,1,1,1))
evalArena(eval,c("Population","EX_glc(e)"),time=10)

## ------------------------------------------------------------------------
par(mar=c(1,1,1,1))
evalArena(eval,c("Population","EX_glc(e)"),phencol=T,time=10)

## ------------------------------------------------------------------------
minePheno(eval)

## ------------------------------------------------------------------------
pmat <- getPhenoMat(eval)

## ------------------------------------------------------------------------
bac1 <- Bac(ecore,type="ecoli_wt")

## ------------------------------------------------------------------------
ecore_aux <- changeBounds(ecore,"EX_o2(e)",lb=0)
bac2 <- Bac(ecore_aux,type="ecoli_aux", setExInf=FALSE)

## ------------------------------------------------------------------------
arena <- Arena(n=50, m=50)
arena <- addOrg(arena,bac1,amount=1)
arena <- addOrg(arena,bac2,amount=1)
arena <- addSubs(arena,100)
eval <- simEnv(arena,time=10)

## ------------------------------------------------------------------------
plotCurves2(eval)

## ------------------------------------------------------------------------
par(mar=c(1,1,1,1))
evalArena(eval,c("Population","EX_glc(e)","EX_ac(e)","EX_o2(e)"),
          time=10)

## ------------------------------------------------------------------------
minePheno(eval)
print(getPhenoMat(eval))

