% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Organism.R
\name{simHum}
\alias{simHum}
\alias{simHum,Human-method}
\title{Function for one simulation iteration for objects of Human class}
\usage{
simHum(
  object,
  arena,
  j,
  sublb,
  bacnum,
  sec_obj = "none",
  cutoff = 1e-06,
  pcut = 1e-06,
  with_shadow = FALSE
)

\S4method{simHum}{Human}(
  object,
  arena,
  j,
  sublb,
  bacnum,
  sec_obj = "none",
  cutoff = 1e-06,
  pcut = 1e-06,
  with_shadow = FALSE
)
}
\arguments{
\item{object}{An object of class Human.}

\item{arena}{An object of class Arena defining the environment.}

\item{j}{The number of the iteration of interest.}

\item{sublb}{A vector containing the substance concentrations in the current position of the individual of interest.}

\item{bacnum}{integer indicating the number of bacteria individuals per gridcell}

\item{sec_obj}{character giving the secondary objective for a bi-level LP if wanted.}

\item{cutoff}{value used to define numeric accuracy.}

\item{pcut}{A number giving the cutoff value by which value of objective function is considered greater than 0.}

\item{with_shadow}{True if shadow cost should be stores (default off).}
}
\value{
Returns the updated enivironment of the \code{arena} parameter with all new positions of individuals on the grid and all new substrate concentrations.
}
\description{
The generic function \code{simHum} implements all neccessary functions for the individuals to update the complete environment.
}
\details{
Human cell individuals undergo the step by step the following procedures: First the individuals are constrained with \code{constrain} to the substrate environment, then flux balance analysis is computed with \code{optimizeLP}, after this the substrate concentrations are updated with \code{consume}, then the cell growth is implemented with \code{cellgrowth}, the potential new phenotypes are added with \code{checkPhen}, finally the conditional function \code{lysis} is performed. Can be used as a wrapper for all important cell functions in a function similar to \code{simEnv}.
}
\examples{
NULL
}
\seealso{
\code{\link{Human-class}}, \code{\link{Arena-class}}, \code{\link{simEnv}}, \code{constrain}, \code{optimizeLP}, \code{consume}, \code{cellgrowth}, \code{checkPhen} and \code{lysis}
}
