% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Arena.R
\name{addEval}
\alias{addEval}
\alias{addEval,Eval-method}
\title{Function for adding a simulation step}
\usage{
addEval(object, arena, replace = F)

\S4method{addEval}{Eval}(object, arena, replace = F)
}
\arguments{
\item{object}{An object of class Eval.}

\item{arena}{An object of class Arena.}

\item{replace}{A boolean variable indicating if the last simulation step should be replaced by the new simulation step \code{arena}.}
}
\description{
The generic function \code{addEval} adds results of a simulation step to an \code{Eval} object.
}
\details{
The function \code{addEval} can be used in iterations to manipulate an \code{Arena} object and store the results in an \code{Eval} object.
}
\examples{
data(Ec_core, envir = environment()) #get Escherichia coli core metabolic model
bac <- Bac(Ec_core,deathrate=0.05,
           minweight=0.05,growtype="exponential") #initialize a bacterium
arena <- Arena(n=20,m=20) #initialize the environment
arena <- addOrg(arena,bac,amount=10) #add 10 organisms
arena <- addSubs(arena,40) #add all possible substances
eval <- simEnv(arena,5)
addEval(eval,arena)
}
\seealso{
\code{\link{Eval-class}} and \code{\link{Arena-class}}
}
