% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bacen_series.R
\name{bacen_series}
\alias{bacen_series}
\title{Fetch Multiple Central Bank Series}
\usage{
bacen_series(series, names, start_date, end_date, httr = TRUE)
}
\arguments{
\item{series}{A numeric vector containing the series IDs from Central Bank API.}

\item{names}{A character vector containing the names corresponding to each series.}

\item{start_date}{A string specifying the start date in "dd/mm/yyyy" format.}

\item{end_date}{A string specifying the end date in "dd/mm/yyyy" format.}

\item{httr}{A logical value indicating whether to use `httr` (`TRUE`) or `httr2` (`FALSE`). Default is `TRUE`.}
}
\value{
A `data.frame` containing the retrieved series data.
}
\description{
This function retrieves data from multiple Central Bank series, given a vector of series IDs and corresponding names.
}
\examples{
series <- c('433', '13005')
names <- c('ipca_br', 'ipca_for')
data <- bacen_series(series, names, "01/01/2013", "31/12/2023", httr = TRUE)

}
