% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/add_column.R
\name{add_column}
\alias{add_column}
\alias{add_column,TidySet,character-method}
\title{Add column}
\usage{
add_column(object, slot, columns)

\S4method{add_column}{TidySet,character}(object, slot, columns)
}
\arguments{
\item{object}{A TidySet object.}

\item{slot}{A TidySet slot.}

\item{columns}{The columns to add.}
}
\value{
A \code{TidySet} object.
}
\description{
Add column to a slot of the TidySet object.
}
\section{Methods (by class)}{
\itemize{
\item \code{object = TidySet,slot = character}: Add a column to any slot
}}

\examples{
relations <- data.frame(
    sets = c(rep("a", 5), "b"),
    elements = letters[seq_len(6)],
    fuzzy = runif(6)
)
TS <- tidySet(relations)
add_column(TS, "relations", data.frame(well = c(
    "GOOD", "BAD", "WORSE",
    "UGLY", "FOE", "HEY"
)))
}
\seealso{
\code{\link{rename_set}}

Other column: 
\code{\link{remove_column}()}

Other methods: 
\code{\link{TidySet-class}},
\code{\link{activate}()},
\code{\link{add_relation}()},
\code{\link{arrange.TidySet}()},
\code{\link{cartesian}()},
\code{\link{complement_element}()},
\code{\link{complement_set}()},
\code{\link{complement}()},
\code{\link{element_size}()},
\code{\link{elements}()},
\code{\link{filter.TidySet}()},
\code{\link{group_by.TidySet}()},
\code{\link{group}()},
\code{\link{incidence}()},
\code{\link{intersection}()},
\code{\link{is.fuzzy}()},
\code{\link{is_nested}()},
\code{\link{move_to}()},
\code{\link{mutate.TidySet}()},
\code{\link{nElements}()},
\code{\link{nRelations}()},
\code{\link{nSets}()},
\code{\link{name_elements<-}()},
\code{\link{name_sets<-}()},
\code{\link{name_sets}()},
\code{\link{power_set}()},
\code{\link{pull.TidySet}()},
\code{\link{relations}()},
\code{\link{remove_column}()},
\code{\link{remove_element}()},
\code{\link{remove_relation}()},
\code{\link{remove_set}()},
\code{\link{rename_elements}()},
\code{\link{rename_set}()},
\code{\link{select.TidySet}()},
\code{\link{set_size}()},
\code{\link{sets}()},
\code{\link{subtract}()},
\code{\link{union}()}
}
\concept{column}
\concept{methods}
