% Generated by roxygen2 (4.0.2): do not edit by hand
\name{findJobs}
\alias{findJobs}
\title{Finds ids of jobs that match a query.}
\usage{
findJobs(reg, ids, pars, jobnames)
}
\arguments{
\item{reg}{[\code{\link{Registry}}]\cr
Registry.}

\item{ids}{[\code{integer}]\cr
Subset of job ids to restrict the result to.
Default is all jobs.}

\item{pars}{[R expression]\cr
All jobs whose parameters match the given expression are selected.
This implies that you have named the parameters when you passed the vectors.
If you forgot to do this you can use \code{.arg1}, \code{.arg2}, etc., to refer to the
the unnamed ones.}

\item{jobnames}{[\code{character}]\cr
Restrict to jobs with stored names. Exact matching is used.}
}
\value{
[\code{integer}]. Ids for jobs which match the query.
}
\description{
Finds ids of jobs that match a query.
}
\examples{
reg = makeRegistry(id = "BatchJobsExample", file.dir = tempfile(), seed = 123)
f = function(x, y) x * y
batchExpandGrid(reg, f, x = 1:2, y = 1:3)
findJobs(reg, pars = (y > 2))
}

