% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ermod-methods.R
\name{ermod_method}
\alias{ermod_method}
\alias{print.ermod}
\alias{plot.ermod_bin}
\alias{coef.ermod}
\alias{summary.ermod}
\title{S3 methods for the classes \code{ermod_*}}
\usage{
\method{print}{ermod}(x, digits = 2, ...)

\method{plot}{ermod_bin}(x, show_orig_data = FALSE, ...)

\method{coef}{ermod}(object, ...)

\method{summary}{ermod}(object, ...)
}
\arguments{
\item{x}{An object of class \code{ermod_*}}

\item{digits}{Number of digits to print}

\item{...}{Additional arguments passed to functions}

\item{show_orig_data}{logical, whether to show the data points in the
model development dataset. Default is \code{FALSE}. Only support plotting
with data that was used in the model development. If you want to use
other data, consider adding geom_point() to the plot manually.}

\item{object}{An object of class \code{ermod_*}}
}
\value{
\itemize{
\item \code{print()} and \code{plot()}: No return value, called for side effects
\item \code{coef()}: Coefficients of the model
\item \code{summary()}: Summary of the model
}
}
\description{
S3 methods for the classes \code{ermod_*}
}
