% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/priors.R
\name{prior.gaussian}
\alias{prior.gaussian}
\title{Use an isotropic Gaussian prior}
\usage{
prior.gaussian(chain, sigma)
}
\arguments{
\item{chain}{Chain obtained using \code{\link{Chain}}}

\item{sigma}{Standard deviation of Gaussian prior}
}
\value{
a list containing the following
\itemize{
    \item `juliavar` the julia variable used to store the prior
    \item `juliacode` the julia code
}
}
\description{
Use a Multivariate Gaussian prior for all network parameters.
Covariance matrix is set to be equal `sigma * I` with `I` being
the identity matrix. Mean is zero.
}
\examples{
\dontrun{
  ## Needs previous call to `BayesFluxR_setup` which is time
  ## consuming and requires Julia and BayesFlux.jl
  BayesFluxR_setup(installJulia=TRUE, seed=123)
  net <- Chain(Dense(5, 1))
  like <- likelihood.feedforward_normal(net, Gamma(2.0, 0.5))
  prior <- prior.gaussian(net, 0.5)
  init <- initialise.allsame(Normal(0, 0.5), like, prior)
  x <- matrix(rnorm(5*100), nrow = 5)
  y <- rnorm(100)
  bnn <- BNN(x, y, like, prior, init)
  sampler <- sampler.SGLD()
  ch <- mcmc(bnn, 10, 1000, sampler)
}

}
