% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dspmix.R
\name{dspmix}
\alias{dspmix}
\title{Density of a mixture of shifted Poisson distributions}
\usage{
dspmix(x, p, lambda, kappa)
}
\arguments{
\item{x}{(an integer) Observation at which the density is evaluated.}

\item{p}{(a vector) Mixture weights.}

\item{lambda}{(a vector) Lambda parameter for each component.}

\item{kappa}{(a vector of integers) Kappa parameter for each component.}
}
\value{
Returns the density evaluated at the observation.
}
\description{
Density function of a mixture of shifted Poisson distributions.
}
\examples{

# a three-component mixture
p = c(0.1,0.5,0.4)
lambda = c(1,2,3)
kappa= c(0,5,1)
dspmix(4,p,lambda,kappa)
dspmix(2,p,lambda,kappa)
dspmix(10,p,lambda,kappa)

}
\references{
\insertRef{basturk_bayes_2021}{BayesMultiMode}
}
