% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixed_point.R
\name{fixed_point}
\alias{fixed_point}
\title{Modal fixed-point algorithm}
\usage{
fixed_point(mcmc, data, pars_names, tol_x = sd(data)/10, show_plot = F)
}
\arguments{
\item{mcmc}{Vector of estimated mixture parameters}

\item{data}{Vector of observations used for estimating the mixture}

\item{pars_names}{Names of the mixture parameters; first element should 
correspond to the mixture proportions; second to the mean; third to the 
standard deviation.}

\item{tol_x}{Tolerance parameter for distance in-between modes; default is sd(data)/10; if two modes are closer than tol_x, only the first estimated mode is kept.}

\item{show_plot}{If true show the data and estimated modes; default is false}
}
\value{
Vector of estimated modes
}
\description{
Algorithm for estimating modes in mixture of Normal distributions.
}
\examples{
mu = c(0,5)
sigma = c(1,2)
p = c(0.5,0.5)

data = c(rnorm(p[1]*100, mu[1], sigma[1]), rnorm(p[2]*100, mu[2], sigma[2]))
params = c(eta = p, mu = mu, sigma = sigma)
pars_names = c("eta", "mu", "sigma")
modes = fixed_point(params, data, pars_names)

}
\references{
\insertRef{carreira-perpinan_mode-finding_2000}{BayesMultiMode}
}
