#' A ClusterTree Example of Emission Model
#' 
#' A propagated \code{\linkS4class{ClusterTree}} object named \code{emission}. This model contains nine variables, indlucing
#' three discrete: Filter State (Fs), Waste Type (W), Burning Regimen (B) and six continuous variables: Metals in Waste (Min), 
#' Metals Emission (Mout), Filter Efficiency (E), Dust Emission (D), CO2 Concentration in Emission (C), Light Penetrability (L). 
#' 
#' @references Lauritzen, Steffen L., and Frank Jensen. Stable local computation with conditional Gaussian distributions. 
#' Statistics and Computing 11.2 (2001): 191-203.
#' 
#' @format The data set contains a propagated \code{\linkS4class{ClusterTree}} object \code{emission} 
#' ready for evidence absorption and making queries.
#' 
#' @usage data(emission)
#' @name emission
#' @docType data
#' 
NULL