% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bayes_ord.R
\name{Bayes_ord}
\alias{Bayes_ord}
\title{Bayesian ordinal regression analysis Estimate the correlation coefficients of treatment variable,
with and without the proportional odds assumption}
\usage{
Bayes_ord(formula, data, structure, U)
}
\arguments{
\item{formula}{a formula expression as for regression models, of the form response ~ predictors.
The response should be a factor (preferably an ordered factor), which will be interpreted as an
ordinal response with levels ordered as in the factor.}

\item{data}{a data frame in which to interpret the variables occurring in the formula.}

\item{structure}{the data structure. i.e., structure = "PO" or structure = "NPO".}

\item{U}{the desirability of each outcome level}
}
\value{
Bayes_ord() returns the regression coefficients, including: (1) estimator coefficients
(2) thresholds coefficients
}
\description{
Bayesian ordinal regression based on cumulative likelihood function Estimate the correlation coefficients
of treatment variable, with or without the proportional odds assumption
}
\details{
This function estimates the coefficients and threshold coefficients.
 Specifically, the numerical utilities U reflect the desirability of each outcome
 level. To do this, in our example, we first set U[1] = 100 and U[5] = 0, and then
 asked physicians to specify numerical values for the intermediate levels, that
 reflect their desirability relative to the best and worst levels.
}
\examples{
\donttest{
### Example One: PO data structure
fm1 = Bayes_ord(response~treatment, example.data, "PO")

### Example Two: NPO data structure
fm2 = Bayes_ord(response~treatment, example.data, "NPO", U = c(100,80,65,25,10,0))
}
}
